******** UPDATES ***************************************************
12/18/12: ADDED 2011
10/18/11: ADDED 2010
10/18/10: ADDED 2009
12/18/09: ADDED 2008

8/27/09: ADDED 2006 & 2007

12/13/07: CHANGED FROM GZIP MACRO TO USING GZIP COMMEND.
*****************************************************************;


LIBNAME myappl '~/jim/data/appliance';
LIBNAME alldat '~/jim/data';

filename app80 pipe 'gunzip -c ~/jim/data/appliance/08423-0038-Data.txt.gz';

filename app84 pipe 'gunzip -c ~/jim/data/appliance/08671-0022-Data.txt.gz';
filename app85 pipe 'gunzip -c ~/jim/data/appliance/08904-0022-Data.txt.gz';
filename app86 pipe 'gunzip -c ~/jim/data/appliance/09113-0022-Data.txt.gz';
filename app87 pipe 'gunzip -c ~/jim/data/appliance/09332-0022-Data.txt.gz';
filename app88 pipe 'gunzip -c ~/jim/data/appliance/da9842.apl.y8889.gz';
filename app89 pipe 'gunzip -c ~/jim/data/appliance/da9841.apl.y8990.gz';
filename app90 pipe 'gunzip -c ~/jim/data/appliance/da9817.apl.y9091.gz';
filename app91 pipe 'gunzip -c ~/jim/data/appliance/da6262.apl.y9192.gz';
filename app92 pipe 'gunzip -c ~/jim/data/appliance/da6440.apl.y9293.gz';
filename app93 pipe 'gunzip -c ~/jim/data/appliance/da6543.apl.y93.gz';
filename app94 pipe 'gunzip -c ~/jim/data/appliance/da6710.apl.y94.gz';
filename app95 pipe 'gunzip -c ~/jim/data/appliance/da2264.apl.y95.gz';
filename app96 pipe 'gunzip -c ~/jim/data/appliance/da2794.apl.gz';
filename app97 pipe 'gunzip -c ~/jim/data/appliance/da2838.apl.gz';
filename app98 pipe 'gunzip -c ~/jim/data/appliance/da2971.apl.gz';
filename app99 pipe 'gunzip -c ~/jim/data/appliance/da3228.apl.gz';
filename app00 pipe 'gunzip -c ~/jim/data/appliance/03396-0021-Data.txt.gz';
filename app01 pipe 'gunzip -c ~/jim/data/appliance/03674-0021-Data.txt.gz';
filename app02 pipe 'gunzip -c ~/jim/data/appliance/03949-0021-Data.txt.gz';
filename app03 pipe 'gunzip -c ~/jim/data/appliance/apl03.txt.gz';
filename app04 pipe 'gunzip -c ~/jim/data/appliance/apl04.txt.gz';
filename app05 pipe 'gunzip -c ~/jim/data/appliance/apl05.txt.gz';
filename app06 pipe 'gunzip -c ~/jim/data/appliance/apl06.txt.gz';
filename app07 pipe 'gunzip -c ~/jim/data/appliance/apl07.txt.gz';
filename app08 pipe 'gunzip -c ~/jim/data/appliance/apl08.txt.gz';
filename app09 pipe 'gunzip -c ~/jim/data/appliance/apl09.txt.gz';
filename app10 pipe 'gunzip -c ~/jim/data/appliance/apl10.txt.gz';

OPTIONS obs=max;


*************** 1980  *************************************************;

DATA appl80;  
INFILE app80;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1980;
newid=9000000+newid;

qyear=19000+qyear;  
RUN;

*************** 1984  *************************************************;

DATA appl84;  
INFILE app84;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1984;
newid=9000000+newid; 

qyear=19000+qyear;  
IF qyear NE 19851; 
RUN;

*************** 1985  *************************************************;

DATA appl85;  
INFILE app85;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1985;

qyear=19000+qyear;
RUN;

PROC SORT;
   BY newid;
RUN;

*************** 1986  *************************************************;

DATA appl86;  
INFILE app86;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1986;

qyear=19000+qyear;
IF qyear NE 19871;
RUN;

PROC SORT;
   BY newid;
RUN;


*******eliminate repeat observations in 19854 and 19861****;
DATA appl85; 
MERGE appl85(IN=in1) appl86(IN=in2);
BY newid; 
if in2 THEN dat2=1;
else dat2=0;
IF in1;
IF dat2=1 THEN DELETE;
RUN; 
DATA appl85;
SET appl85;
newid=9000000+newid;
RUN;


*************** 1987  *************************************************;

DATA appl87;  
INFILE app87;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1987;

qyear=19000+qyear;
IF qyear NE 19881;
RUN;
*************** 1988  *************************************************;

DATA appl88;  
INFILE app88;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1988;

qyear=19000+qyear;
IF qyear NE 19891;
RUN;
*************** 1989  *************************************************;

DATA appl89;  
INFILE app89;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1989;

qyear=19000+qyear;
IF qyear NE 19901;

RUN;

*************** 1990  *************************************************;

DATA appl90;  
INFILE app90;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1990;

qyear=19000+qyear;
IF qyear NE 19911;

RUN;

*************** 1991  *************************************************;

DATA appl91;  
INFILE app91;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
      year=1991;

qyear=19000+qyear;
IF qyear NE 19921;

RUN;
*************** 1992  *************************************************;

DATA appl92;  
INFILE app92;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1992;

qyear=19000+qyear;
IF qyear NE 19931;

RUN;

*************** 1993  *************************************************;

DATA appl93;
INFILE app93;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1993;

qyear=19000+qyear;
IF qyear NE 19941;

RUN;

*************** 1994  *************************************************;

DATA appl94;
INFILE app94;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1994;

qyear=19000+qyear;
IF qyear NE 19951;

RUN;

*************** 1995  *************************************************;

DATA appl95;
INFILE app95;
INPUT qyear 1-3 newid 4-11 seqno 12-14 rec_orig $ 18 applianc 19-20 
   numapp 22-23 appstat $ 25;
   year=1995;

qyear=19000+qyear;

RUN;

***************************************************************************
MACRO FOR 1996-2010
***************************************************************************;

%MACRO read(yr);
 
  DATA appl&yr; 
   INFILE app&yr; 
   INPUT qyear 1-5 newid 6-13 seqno 14-16 rec_orig $ 20 applianc 21-22
   numapp 24-25 appstat $ 27; 

   IF &yr GE 96 THEN year=1900+&yr;
   ELSE IF &yr LT 96 THEN year=2000+&yr;

   IF year=1996 AND qyear=19971 THEN DELETE;
   IF year=1997 AND qyear=19981 THEN DELETE;
   IF year=1998 AND qyear=19991 THEN DELETE;
   IF year=1999 AND qyear=20001 THEN DELETE;
   IF year=2000 AND qyear=20011 THEN DELETE;
   IF year=2001 AND qyear=20021 THEN DELETE;
   IF year=2002 AND qyear=20031 THEN DELETE;
   IF year=2003 AND qyear=20041 THEN DELETE;

   IF year=2005 AND qyear=20061 THEN DELETE;
   IF year=2006 AND qyear=20071 THEN DELETE;
   IF year=2007 AND qyear=20081 THEN DELETE;
   IF year=2008 AND qyear=20091 THEN DELETE;
   IF year=2009 AND qyear=20101 THEN DELETE;
   IF year=2010 AND qyear=20111 THEN DELETE;

PROC MEANS; 
RUN; 


%MEND read;
    
***************************************************************************
* MACRO FOR SURVEY YEARS 2011 AND AFTER
***************************************************************************;
%MACRO read2(yr);

  PROC IMPORT DATAFILE="~/jim/data/appliance/apl&yr..csv"
     OUT=appl_dat
     DBMS=CSV
     REPLACE;
     GETNAMES=YES;
  RUN;
 
 DATA appl&yr; 
   SET appl_dat(RENAME=(qyear=temp1 MAJCODE=temp3 MAJAPPLQ=numapp)); 
 
   year=2000+&yr;
   qyear=temp1*1;   
   applianc=temp3*1;   

   /*   IF year=2011 AND qyear=20121 THEN DELETE;*/
      
   KEEP qyear newid seqno applianc numapp year;   

 RUN; 
 PROC MEANS;
 RUN;
%MEND read2;





%read(96);
%read(97);
%read(98);
%read(99);
%read(00);
%read(01);
%read(02);
%read(03);
%read(04);
%read(05);
%read(06);
%read(07);
%read(08);
%read(09);
%read(10);

%read2(11);


*******eliminate repeat observations in 19955 and 19961****;

PROC SORT DATA=appl95;
   BY newid;
RUN;

PROC SORT DATA=appl96;
   BY newid;
RUN;

DATA temp;
SET appl96;
BY newid;
IF first.newid;
RUN;
DATA appl95; 
MERGE appl95(IN=in1) temp(IN=in2);
BY newid; 
if in2 THEN dat2=1;
else dat2=0;
IF in1;
IF dat2=1 THEN DELETE;
RUN; 

******* DELETE OBS IN 045 THAT ARE ALSO IN 051 ****;
PROC SORT DATA=appl04;
   BY newid;
RUN;

PROC SORT DATA=appl05;
   BY newid;
RUN;

DATA temp;
SET appl05;
BY newid;
IF first.newid;
RUN;
DATA appl04; 
MERGE appl04(IN=in1) temp(IN=in2);
BY newid; 
if in2 THEN dat2=1;
else dat2=0;
IF in1;
IF dat2=1 THEN DELETE;
RUN; 



********************************************************************
Stack all the data 
********************************************************************;

DATA temp;
SET appl80 appl84 appl85 appl86 appl87 appl88 appl89
    appl90 appl91 appl92 appl93 appl94 appl95 appl96 
    appl97 appl98 appl99 appl00 appl01 appl02 appl03 
    appl04 appl05 appl06 appl07 appl08 appl09 appl10
    appl11;

lft5=floor(newid/10);
rt1=newid-lft5*10;

********************************************************
Create separate dummies for each appliance
NOTE: in 86 and before no tv or stero info
********************************************************;

IF applianc=1 OR applianc=2 OR applianc=4 THEN stove=1;
   ELSE stove=0;
IF applianc=3 THEN microw=1;
   ELSE microw=0;
IF applianc=5 THEN frig=1;
   ELSE frig=0;
IF applianc=6 THEN freezer=1;
   ELSE freezer=0;
IF applianc=7 OR applianc=8 THEN dishw=1;
   ELSE dishw=0;
IF applianc=9 THEN disposal=1;
   ELSE disposal=0;
IF applianc=10 THEN washer=1;
   ELSE washer=0;
IF applianc=11 THEN dryer=1;
   ELSE dryer=0;
IF applianc=12 THEN tv=1;
   ELSE tv=0;
IF applianc=13 THEN computer=1;
   ELSE computer=0;
IF applianc=14 THEN stereo=1;
   ELSE stereo=0;
IF applianc=15 THEN vcr=1;
   ELSE vcr=0;

PROC SORT;
   BY newid;
PROC MEANS SUM NOPRINT;
   BY newid;
   ID year;
   VAR stove microw frig freezer disposal dishw 
       washer dryer tv computer stereo vcr;
   OUTPUT OUT=appl_all(DROP=_FREQ_ _TYPE_) SUM=;
RUN;

DATA alldat.appl_all_80_11;
SET appl_all;
stove=min(1,stove);
microw=min(1,microw); 
frig=min(1,frig); 
freezer=min(1,freezer); 
disposal=min(1,disposal); 
dishw=min(1,dishw);
washer=min(1,washer); 
dryer=min(1,dryer); 
tv=min(1,tv); 
computer=min(1,computer); 
stereo=min(1,stereo); 
vcr=min(1,vcr);
RUN;

PROC MEANS DATA=alldat.appl_all_80_11;
RUN;
PROC SORT DATA=alldat.appl_all_80_11;
BY YEAR;
PROC MEANS DATA=alldat.appl_all_80_11;
BY YEAR;
RUN;

PROC SORT DATA=alldat.appl_all_80_11;
BY newid;
RUN;
PROC SORT DATA=alldat.appl_all_80_10;
BY newid;
RUN;

PROC COMPARE BASE=alldat.appl_all_80_11
	     COMPARE=alldat.appl_all_80_10;
   WHERE year LE 2009;
RUN;

ENDSAS;



